<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitQuantityEventInterface.php 2020-02-13
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
namespace Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\SellingUnitBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\AbstractQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\AvailableQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\QuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use Psr\EventDispatcher\StoppableEventInterface;

interface OnGetSellingUnitAvailableQuantityEventInterface extends BasicSellingUnitEventInterface, StoppableEventInterface
{
    /**
     * @return AvailableQuantity
     */
    public function quantity(): ?AvailableQuantity;


    /**
     * @param ModifierQuantityInterface $quantity
     *
     * @return void
     */
    public function addQuantity(ModifierQuantityInterface $quantity): void;
    public function stopPropagation(): void;
}